package mcfall.raytracer.tests;

import mcfall.math.ColumnVector;
import mcfall.math.Point;
import mcfall.math.Ray;
import mcfall.math.Vector;
import mcfall.raytracer.objects.GenericPlane;

import org.junit.Before;
import org.junit.Test;

public class TestPointNormalPlane {
	GenericPlane pnp;
	@Before
	public void setUp() throws Exception {
	}
	@Test
	public void testPointNormalPlane() {
		Vector n = new ColumnVector(4,new double[]{1d,1d,0d,0d});
		n = n.normalize();
		Point p = new Point(0d,0d,0d);
		pnp = new GenericPlane();
		pnp.forcePlaneToPointNormal(p,n);
		Vector rv = new ColumnVector(3,new double[]{-1d,-1d,0d});
		rv = rv.normalize();
		Ray r = new Ray(new Point(1d,1d,0d),rv);
		assert(pnp.hitTime(r).get(0).hitTime==1d);
	}
	@Test
	public void testPointNormalPlane2() {
		Vector n = new ColumnVector(4,new double[]{1d,1d,0d,0d});
		n = n.normalize();
		Point p = new Point(0d,1d,0d);
		pnp = new GenericPlane();
		pnp.forcePlaneToPointNormal(p,n);
		Vector rv = new ColumnVector(3,new double[]{-10d,-10d,0d});
		rv = rv.normalize();
		Ray r = new Ray(new Point(2d,1d,0d),rv);
		assert(pnp.hitTime(r).size()==1);
		TestCase.assertAlmostEquals(pnp.hitTime(r).get(0).hitTime,Math.sqrt(2d));
	}

}